/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.FilteredImageSource;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;

public class Jigsaw
extends Applet
implements ActionListener,
MouseListener,
MouseMotionListener,
WindowListener {
    int wSize;
    int hSize;
    int rows;
    int cols;
    int iWidth;
    int iHeight;
    int jPosX;
    int jPosY;
    int appW;
    int appH;
    int hlpImgFade = -1;
    boolean hlpImgGray = false;
    boolean avoidCenter = false;
    boolean canRotate = false;
    boolean keepClear = false;
    int autoSnap = 3;
    int cutting = 0;
    int ts = 0;
    int overlap = 16;
    int totalPieces;
    int[] points;
    int w = 0;
    int h = 0;
    int vAlign = 1;
    Color bgColor = Color.lightGray;
    Color txColor = Color.black;
    Color ofColor = Color.black;
    Color ifColor = Color.black;
    Color pkColor = Color.red;
    Color bdColor = new Color(0xFFBFBF);
    Graphics offScrGr;
    Image offScrImg;
    Image img1 = null;
    String imgName;
    JigsawPiece[] jp;
    JigsawPiece selPP = null;
    Random rNum = new Random();
    int xmOff = 0;
    int ymOff = 0;
    Label l1;
    Label l2;
    public int STEP_SIZE = 20;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Solve")) {
            int n = 0;
            while (n < this.rows) {
                int n2 = 0;
                while (n2 < this.cols) {
                    JigsawPiece jigsawPiece = this.jp[n * this.cols + n2];
                    jigsawPiece.setPosition(jigsawPiece.getBaseX(), jigsawPiece.getBaseY());
                    jigsawPiece.setOrientation(0);
                    ++n2;
                }
                ++n;
            }
        }
        if (string.equals("Breakup")) {
            this.breakupPuzzle(false);
        }
        if (string.equals("Tidy pieces")) {
            this.breakupPuzzle(true);
        }
        if (string.equals("?")) {
            this.showAbout();
        }
        this.repaint();
    }

    private void breakupPuzzle(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.rows) {
            int n6 = 0;
            while (n6 < this.cols) {
                boolean bl2 = true;
                JigsawPiece jigsawPiece = this.jp[n5 * this.cols + n6];
                if (bl) {
                    n3 = jigsawPiece.getX();
                    n4 = jigsawPiece.getY();
                    if (n3 >= this.jPosX && n3 <= this.jPosX + this.iWidth - this.w && n4 >= this.jPosY && n4 <= this.jPosY + this.iHeight - this.h) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    do {
                        if (!bl && this.canRotate) {
                            jigsawPiece.setOrientation((int)(this.rNum.nextDouble() * 3.0));
                        }
                        n = (int)(this.rNum.nextDouble() * (double)(this.appW - this.w - 20 - this.overlap)) + 10;
                        n2 = (int)(this.rNum.nextDouble() * (double)(this.appH - this.h - 20 - this.overlap)) + 10;
                    } while (this.keepClear && n > this.jPosX - this.w - this.overlap && n2 >= this.jPosY - this.h - this.overlap && n2 <= this.jPosY + this.iHeight);
                    jigsawPiece.setPosition(n, n2);
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void cutupPicture(Image image) {
        this.w = this.iWidth / this.cols;
        this.h = this.iHeight / this.rows;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[4];
        int n6 = this.w / 2;
        int n7 = this.h / 2;
        boolean bl5 = false;
        boolean bl6 = false;
        this.overlap = this.STEP_SIZE - 2;
        int n8 = 0;
        while (n8 < this.rows) {
            n2 = 0;
            int n9 = 0;
            while (n9 < this.cols) {
                Object object;
                do {
                    n4 = (int)(this.rNum.nextDouble() * (double)(this.appW - this.w - 10)) + 5;
                    n5 = (int)(this.rNum.nextDouble() * (double)(this.appH - this.h - 10)) + 5;
                } while (n4 < this.jPosX + this.iWidth + 5 && n4 > this.jPosX - this.w - 5 && n5 < this.jPosY + this.iHeight + 5 && n5 > this.jPosY - this.h - 5 && this.avoidCenter);
                if (n8 == 0) {
                    nArray[0] = 0;
                } else {
                    object = this.jp[(n8 - 1) * this.cols + n9];
                    nArray[0] = -((JigsawPiece)object).getFace(2);
                }
                if (n9 == this.cols - 1) {
                    nArray[1] = 0;
                } else {
                    nArray[1] = this.h / 2;
                    if (this.rNum.nextDouble() * 2.0 - 1.0 < 0.0) {
                        nArray[1] = -nArray[1];
                    }
                    if (nArray[0] > 0) {
                        nArray[1] = nArray[1] > 0 ? nArray[1] + (this.overlap - 3) : nArray[1] - (this.overlap - 3);
                    }
                }
                if (n8 == this.rows - 1) {
                    nArray[2] = 0;
                } else {
                    nArray[2] = this.w / 2;
                    if (this.rNum.nextDouble() * 2.0 - 1.0 < 0.0) {
                        nArray[2] = -nArray[2];
                    }
                }
                if (n9 == 0) {
                    nArray[3] = 0;
                } else {
                    object = this.jp[n8 * this.cols + (n9 - 1)];
                    nArray[3] = -((JigsawPiece)object).getFace(1);
                }
                object = new int[4];
                int n10 = 0;
                while (n10 < 4) {
                    object[n10] = nArray[n10] > 0 ? this.overlap - 3 : 0;
                    ++n10;
                }
                int n11 = this.canRotate ? (int)(this.rNum.nextDouble() * 3.0) : 0;
                this.jp[n] = new JigsawPiece(image, this.overlap, n2 - object[3], n3 - object[0], this.w + object[3] + object[1], this.h + object[0] + object[2], this.jPosX, this.jPosY, n4, n5, nArray[0], nArray[1], nArray[2], nArray[3], this.points, n11);
                ++n;
                n2 += this.w;
                ++n9;
            }
            n3 += this.h;
            ++n8;
        }
        this.cutting = 0;
    }

    public void dloadImage(String string) {
        try {
            Jigsaw jigsaw = this;
            synchronized (jigsaw) {
                Image image = this.getImage(new URL(this.getDocumentBase(), string)).getScaledInstance(this.iWidth, this.iHeight, 2);
                if (this.hlpImgFade > -1) {
                    this.img1 = this.createImage(new FilteredImageSource(image.getSource(), new JigsawCutter(this.hlpImgFade, this.hlpImgGray, 0, 0, 0, 0, 0, 0, 0, this.points)));
                }
                this.cutupPicture(image);
                this.repaint();
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("MalformedURLException: " + malformedURLException);
        }
    }

    private JigsawPiece findPiece(int n, int n2) {
        int n3 = this.rows - 1;
        while (n3 >= 0) {
            int n4 = this.cols - 1;
            while (n4 >= 0) {
                JigsawPiece jigsawPiece = this.jp[n3 * this.cols + n4];
                if (jigsawPiece.isOver(n, n2)) {
                    return jigsawPiece;
                }
                --n4;
            }
            --n3;
        }
        return null;
    }

    public void init() {
        Cursor cursor = new Cursor(12);
        this.appW = this.getBounds().width;
        this.appH = this.getBounds().height;
        this.offScrImg = this.createImage(this.appW, this.appH);
        this.offScrGr = this.offScrImg.getGraphics();
        this.setLayout(new FlowLayout(0, 3, 3));
        Button button = new Button("?");
        this.add(button);
        Button button2 = new Button("Breakup");
        this.add(button2);
        this.l2 = new Label("");
        this.add(this.l2);
        Button button3 = new Button("Tidy pieces");
        this.add(button3);
        Button button4 = new Button("Solve");
        this.add(button4);
        this.l1 = new Label(" Jigsaw Solved ! ");
        this.add(this.l1);
        button2.setCursor(cursor);
        button3.setCursor(cursor);
        button4.setCursor(cursor);
        button.setCursor(cursor);
        button.setFont(new Font("helvetica", 1, 13));
        button.setForeground(Color.white);
        button.setBackground(Color.darkGray);
        button2.addActionListener(this);
        button3.addActionListener(this);
        button4.addActionListener(this);
        button.addActionListener(this);
        this.readParams();
        this.setBackground(this.bgColor);
        this.l1.setBackground(this.bgColor);
        this.l2.setBackground(this.bgColor);
        this.l1.setForeground(this.txColor);
        this.points = new int[this.STEP_SIZE + 1];
        int n = 0;
        double d = 0.0;
        while (d < Math.PI) {
            double d2 = Math.sin(d);
            this.points[n] = (int)((double)((this.STEP_SIZE - 2) / 2) * d2);
            d += Math.PI / (double)this.STEP_SIZE;
            ++n;
        }
        this.totalPieces = this.rows * this.cols;
        this.jPosX = this.appW - this.iWidth - 7;
        switch (this.vAlign) {
            case 0: {
                this.jPosY = 5;
                break;
            }
            case 4: {
                this.jPosX = this.appW / 2 - this.iWidth / 2;
            }
            case 1: {
                this.jPosY = this.appH / 2 - this.iHeight / 2;
                break;
            }
            case 2: {
                this.jPosY = this.appH - this.iHeight - 6;
                break;
            }
            case 3: {
                this.jPosY = 34;
                break;
            }
        }
        this.jp = new JigsawPiece[this.rows * this.cols];
        this.dloadImage(this.imgName);
        this.breakupPuzzle(false);
        this.repaint();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) > 0 && this.canRotate) {
            this.selPP = this.findPiece(mouseEvent.getX(), mouseEvent.getY());
            if (this.selPP != null) {
                this.selPP.setOrientation(1);
                this.repaint();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selPP != null) {
            int n = mouseEvent.getX() - this.xmOff;
            int n2 = mouseEvent.getY() - this.ymOff;
            if (n < 5) {
                n = 5;
            }
            if (n > this.appW - this.w - 3) {
                n = this.appW - this.w - 3;
            }
            if (n2 < 8) {
                n2 = 8;
            }
            if (n2 > this.appH - this.h - 3) {
                n2 = this.appH - this.h - 3;
            }
            this.selPP.setPosition(n, n2);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        JigsawPiece jigsawPiece = this.selPP;
        this.selPP = this.findPiece(mouseEvent.getX(), mouseEvent.getY());
        if (jigsawPiece != this.selPP) {
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) > 0 || !this.canRotate) {
            if (this.selPP != null) {
                this.xmOff = mouseEvent.getX() - this.selPP.getX();
                this.ymOff = mouseEvent.getY() - this.selPP.getY();
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selPP != null) {
            int n = this.selPP.getX();
            int n2 = this.selPP.getY();
            int n3 = this.selPP.getBaseX();
            int n4 = this.selPP.getBaseY();
            if (n > n3 - this.autoSnap && n < n3 + this.autoSnap && n2 > n4 - this.autoSnap && n2 < n4 + this.autoSnap) {
                this.selPP.setPosition(n3, n4);
            }
        }
        this.selPP = null;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        boolean bl = true;
        this.offScrGr.setColor(this.bgColor);
        this.offScrGr.fillRect(0, 0, this.appW, this.appH);
        this.offScrGr.setColor(this.ofColor);
        this.offScrGr.drawRect(0, 0, this.appW - 2, this.appH - 2);
        if (this.img1 != null) {
            this.offScrGr.drawImage(this.img1, this.jPosX, this.jPosY, this);
        } else {
            this.offScrGr.setColor(this.bdColor);
            this.offScrGr.fillRect(this.jPosX, this.jPosY, this.iWidth, this.iHeight);
        }
        this.offScrGr.setColor(this.ifColor);
        this.offScrGr.drawRect(this.jPosX - 1, this.jPosY - 1, this.iWidth + 2, this.iHeight + 2);
        int n4 = 0;
        while (n4 < this.rows) {
            n2 = 0;
            while (n2 < this.cols) {
                JigsawPiece jigsawPiece = this.jp[n3++];
                int n5 = jigsawPiece.getX();
                n = jigsawPiece.getY();
                Image image = jigsawPiece.getPiece();
                int n6 = image.getWidth(this);
                int n7 = image.getHeight(this);
                switch (jigsawPiece.getOrientation()) {
                    case 0: {
                        this.offScrGr.drawImage(image, n5, n, this);
                        break;
                    }
                    case 1: {
                        this.offScrGr.drawImage(image, n5, n, n5 + n6, n + n7, n6, 0, 0, n7, this);
                        break;
                    }
                    case 2: {
                        this.offScrGr.drawImage(image, n5, n, n5 + n6, n + n7, n6, n7, 0, 0, this);
                        break;
                    }
                    case 3: {
                        this.offScrGr.drawImage(image, n5, n, n5 + n6, n + n7, 0, n7, n6, 0, this);
                        break;
                    }
                }
                if (bl && (n5 != jigsawPiece.getBaseX() || n != jigsawPiece.getBaseY() || jigsawPiece.getOrientation() != 0)) {
                    bl = false;
                }
                ++n2;
            }
            ++n4;
        }
        if (this.selPP != null) {
            n2 = this.selPP.getX();
            int n8 = this.selPP.getY();
            Image image = this.selPP.getPiece();
            n = image.getWidth(this);
            int n9 = image.getHeight(this);
            switch (this.selPP.getOrientation()) {
                case 0: {
                    this.offScrGr.drawImage(image, n2, n8, this);
                    break;
                }
                case 1: {
                    this.offScrGr.drawImage(image, n2, n8, n2 + n, n8 + n9, n, 0, 0, n9, this);
                    break;
                }
                case 2: {
                    this.offScrGr.drawImage(image, n2, n8, n2 + n, n8 + n9, n, n9, 0, 0, this);
                    break;
                }
                case 3: {
                    this.offScrGr.drawImage(image, n2, n8, n2 + n, n8 + n9, 0, n9, n, 0, this);
                    break;
                }
            }
            this.offScrGr.setColor(this.pkColor);
            this.offScrGr.drawRect(this.selPP.getX(), this.selPP.getY(), this.selPP.getW(), this.selPP.getH());
        }
        if (bl) {
            this.l1.setText(" Jigsaw Solved ! ");
        } else {
            this.l1.setText("");
        }
        graphics.drawImage(this.offScrImg, 0, 0, this);
    }

    public void randomizePosition(JigsawPiece jigsawPiece, boolean bl) {
        int n = this.iWidth / this.cols;
        int n2 = this.iHeight / this.rows;
        int n3 = 0;
        int n4 = 0;
        do {
            n3 = (int)(this.rNum.nextDouble() * (double)(this.appW - n - 20 - this.overlap)) + 10;
            n4 = (int)(this.rNum.nextDouble() * (double)(this.appH - n2 - 20 - this.overlap)) + 10;
        } while (n3 < this.jPosX + this.iWidth + 5 + this.overlap && n3 > this.jPosX - n - 5 && n4 < this.jPosY + this.iHeight + 5 + this.overlap && n4 > this.jPosY - n2 - 5 && bl);
        jigsawPiece.setPosition(n3, n4);
    }

    private void readParams() {
        this.imgName = this.getParameter("Image");
        String string = this.getParameter("ImgWidth");
        if (string != null) {
            this.iWidth = new Integer(string);
        }
        if ((string = this.getParameter("ImgHeight")) != null) {
            this.iHeight = new Integer(string);
        }
        if ((string = this.getParameter("Rows")) != null) {
            this.rows = new Integer(string);
        }
        if ((string = this.getParameter("Cols")) != null) {
            this.cols = new Integer(string);
        }
        if ((string = this.getParameter("DimHelpImage")) != null) {
            this.hlpImgFade = new Integer(string);
        }
        if ((string = this.getParameter("HelpImageGrayed")) != null && string.equals("true")) {
            this.hlpImgGray = true;
        }
        if ((string = this.getParameter("AutoSnap")) != null) {
            this.autoSnap = new Integer(string);
        }
        if ((string = this.getParameter("CanRotate")) != null && string.equals("true")) {
            this.canRotate = true;
        }
        if ((string = this.getParameter("KeepBoardClear")) != null && string.equals("true")) {
            this.keepClear = true;
        }
        if ((string = this.getParameter("BgColor")) != null) {
            this.bgColor = Color.decode(string);
        }
        if ((string = this.getParameter("TextColor")) != null) {
            this.txColor = Color.decode(string);
        }
        if ((string = this.getParameter("OuterFrameColor")) != null) {
            this.ofColor = Color.decode(string);
        }
        if ((string = this.getParameter("InnerFrameColor")) != null) {
            this.ifColor = Color.decode(string);
        }
        if ((string = this.getParameter("BoardColor")) != null) {
            this.bdColor = Color.decode(string);
        }
        if ((string = this.getParameter("SelectColor")) != null) {
            this.pkColor = Color.decode(string);
        }
        if ((string = this.getParameter("PictureAlign")) != null) {
            if (string.equals("top")) {
                this.vAlign = 0;
            }
            if (string.equals("spaced")) {
                this.vAlign = 3;
            }
            if (string.equals("bottom")) {
                this.vAlign = 2;
            }
            if (string.equals("center")) {
                this.vAlign = 4;
            }
        }
        if ((string = this.getParameter("Connector")) != null) {
            switch (new Integer(string)) {
                case 0: {
                    this.STEP_SIZE = 16;
                    break;
                }
                case 1: {
                    this.STEP_SIZE = 18;
                    break;
                }
                case 2: {
                    this.STEP_SIZE = 20;
                    break;
                }
                case 3: {
                    this.STEP_SIZE = 22;
                    break;
                }
                case 4: {
                    this.STEP_SIZE = 24;
                    break;
                }
            }
        }
        if (this.autoSnap < 0) {
            this.autoSnap = 0;
        }
        if (this.autoSnap > 15) {
            this.autoSnap = 15;
        }
        if (this.hlpImgFade > 100) {
            this.hlpImgFade = 100;
        }
    }

    public void showAbout() {
        Label[] labelArray = new Label[6];
        Frame frame = new Frame("About");
        ((Component)frame).setBackground(Color.lightGray);
        frame.setLayout(new FlowLayout(0, 2, 2));
        Panel panel = new Panel();
        frame.add(panel);
        panel.setLayout(new BorderLayout(1, 1));
        Label label = new Label(" Jigsaw ");
        panel.add("North", label);
        label.setFont(new Font("helvetica", 1, 32));
        label.setForeground(Color.yellow);
        label.setBackground(Color.black);
        Panel panel2 = new Panel();
        panel.setBackground(Color.lightGray);
        panel.add("Center", panel2);
        panel2.setLayout(new GridLayout(3, 2, 0, 0));
        panel2.setBackground(Color.lightGray);
        labelArray[0] = new Label("Version");
        panel2.add(labelArray[0]);
        labelArray[3] = new Label("1.0");
        panel2.add(labelArray[3]);
        labelArray[1] = new Label("Author");
        panel2.add(labelArray[1]);
        labelArray[4] = new Label("Steve White");
        panel2.add(labelArray[4]);
        labelArray[2] = new Label("Date");
        panel2.add(labelArray[2]);
        labelArray[5] = new Label("07/07/1999");
        panel2.add(labelArray[5]);
        TextArea textArea = new TextArea("", 6, 45, 1);
        panel.add("South", textArea);
        ((Component)textArea).setBackground(Color.white);
        textArea.setFont(new Font("helvetica", 0, 9));
        textArea.setEditable(false);
        textArea.append("This applet has been written by Steve White and it is FREE for non-commercial use.");
        textArea.append("\nALL users implementing this applet on their own web pages should read and agree to the conditions of use in the readme file supplied with the applet.");
        textArea.append("\nCommercial users should ");
        textArea.append("ask for permission BEFORE using this applet.\n\n");
        textArea.append("The homepage for this applet is http://home.sol.no/~svw2/puzzles\n\n");
        textArea.append("You can contact me via sw_11@hotmail.com.");
        int n = 0;
        while (n < 6) {
            labelArray[n].setFont(new Font("helvetica", 1, 16));
            labelArray[n].setBackground(Color.lightGray);
            if (n < 3) {
                labelArray[n].setForeground(new Color(0, 64, 0));
            }
            ++n;
        }
        ((Component)frame).setSize(256, 280);
        frame.setResizable(false);
        ((Component)frame).setVisible(true);
        ((Component)frame).setLocation(150, 100);
        frame.addWindowListener(this);
    }

    public void start() {
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        window.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

